# Collaborative Authoring Setup Script
This PowerShell script helps setup a Microsoft Entra ID app and a SharePoint site for use with Collaborative Authoring.

## Setting up PowerShell
### Windows
Install Powershell 7 (https://learn.microsoft.com/en-us/powershell/scripting/install/installing-powershell-on-windows?view=powershell-7.5)
- Note: This is a separate application on Windows from the pre-installed Powershell

**Open PowerShell 7:** Search for "PowerShell 7" then right-click and select "Run as administrator" (recommended).

Run the following command to install the PnP Module:
Install-Module PnP.PowerShell

### macOS
Follow Microsoft's instructions for installing PowerShell onto MacOS:
https://learn.microsoft.com/en-us/powershell/scripting/install/installing-powershell-on-macos

**Open PowerShell:** Open Terminal, type pwsh, and press Enter.

Run the following command to install the PnP Module:
Install-Module PnP.PowerShell

### Running the Script
1. Download: Save collab_auth_setup_script.ps1 to a chosen directory.
2. Navigate: In PowerShell/Terminal, cd to the script's directory.
3. Execute: .\collab_auth_setup_script.ps1

**macOS/Linux:** Use ./ before script name (e.g., ./collab_auth_setup_script.ps1).

## What to Expect When Running the Script
The script guides you through these steps:

### Create a temporary Entra ID app to serve as the admin app
- You will need to provide the tenant domain for your organization (e.g. veeva.onmicrosoft.com).
- The admin app will have the permissions necessary to create a SharePoint site, edit the site's security settings, and delete itself at the end of the script.
   - SharePoint Delegated Permissions: AllSites.FullControl
   - Graph Delegated Permissions: Application.ReadWrite.All, Group.ReadWrite.All
   - All permissions must be granted admin consent
- If the admin app already exists, you will need to provide the app's client ID or delete the app and re-run the script. You should only need to provide an existing client ID if the script did not fully execute previously (as the script deletes the app at the end).
- The admin admin app will attempt to delete itself at the end of the script. If it fails, you will need to manually delete the app.

### Create or Provide an Entra ID app to be used for the Collaborative Authoring configuration
- You will need to provide the tenant domain for your organization (e.g. veeva.onmicrosoft.com), if not provided in step 1.
- If you are enabling collaborative authoring for the first time, the script will create an app that has the Sites.Selected permission and by the end of the script the specified SharePoint site will be registered to that permission.
- The app can optionally include the permissions necessary for the features noted below.
- If you already have collaborative authoring enabled, please have the existing app's client ID ready.
   - Required and optional permissions for an existing app must be added manually.

#### Entra ID App Permissions

- **Required for Collaborative Authoring:** Sites.Selected
- **Optional for automatic external user invites:** Directory.ReadWrite.All & User.Invite.All
- **Optional for automatic adding of participants during workflows:** User.Read.All
- All permissions are application permissions for Microsoft Graph

### Create or Provide a SharePoint site
- You will need to provide your organization's SharePoint admin URL (e.g. https://veeva-admin.sharepoint.com/).
- If you are enabling collaborative authoring for the first time, you will need to provide a name and alias for the site.
   - The alias of a site is what shows up in the site's URL (e.g. MySiteAlias -> https://veeva.sharepoint.com/sites/MySiteAlias).
      - The alias can only contain letters, numbers, periods (.), underscores (_), and dashes (-).
      - The alias cannot start with a period or an underscore.
      - The alias cannot end with a period.
- If you already have collaborative authoring enabled, please have the existing site's URL ready (e.g. https://veeva.sharepoint.com/sites/MySite).

### Harden the security of your SharePoint site
- In this step, several security settings for the SharePoint site will be modified to prevent non-admin access to Collaborative Authoring documents.
   - Disables member sharing. Only site owners will be allowed to share files, folders, and the site.
   - Disables requesting access to the site and the site's files.
   - Disables deleting files for members with the Contribute permission level.
   - Removes member and visitor groups from the documents library. Only the owner group will have default access.
- This step can be skipped if you have already performed theese steps in the past (if you had previously enabled collaborative authoring). Or, if your organization has different requirements for security, you can manually change settings on the SharePoint site.
- If you use a custom document library for your site, you will be prompted for the name of the document library.
   - Most customers will use the default 'Documents' document library.

### Register the SharePoint site with the Collaborative Authoring app's Sites.Selected permission
- This step registers the SharePoint site to the Collaborative Authoring Entra ID app's list of site permissions.
   - The registration is between the site and the app. So, if the app's Sites.Selected permission is removed, it can be re-added without having to re-register.

## Troubleshooting
- The script will first verify that you have the appropriate version of PowerShell and the PnP Module. If you encounter errors here, please ensure you have followed the steps noted in Setting Up PowerShell above.
- This script is not signed, so if you are on a Windows machine, you may encounter an unsigned script error.
  - If you don't already know your security policy, you can see it with the command "Get-ExecutionPolicy".
  - If you encounter this, you will need to run the command "Set-ExecutionPolicy -ExecutionPolicy Unrestricted".
  - You may also need to check the "Unblock" option in the Security section of the script's File Properties.
  - You should return your execution policy to its original setting after you are done with the script.
- For further issues, provide the Collab-Auth-Setup-Log-*.txt to Veeva for review.