﻿# Creates Admin App, new site, and grants permission for app to access site 

# Prerequisites:
# 1. Install the PnP PowerShell module** (recommended to run in PowerShell 7):
# Install-Module PnP.PowerShell -RequiredVersion 2.12
# 2. Ensure you have appropriate permissions to create sites


$adminUrl = "https://test-admin.sharepoint.com"
$siteBaseUrl = "https://test.sharepoint.com/sites/"
$siteTitle = "Site Title"
$owner = "owner@domain.com"
$alias = "siteAlias"
$tenantUrl = "domain.com"
$appId = "appId"
$displayName = "Display Name"
$siteUrl = $siteBaseUrl + $alias # https://test.sharepoint.com/sites/siteAlias

# Only one of the following is required
$entraIDApp = "entraIdApp" # id of existing entra app if you already have one
$adminAppName = "Admin App Name"

# Function to create a SharePoint site with various configuration options
    # Connect to Sharepoint admin
    try {
        if ($entraIDApp -ne $null) {
            $clientId = $entraIDApp
            Write-Host "Using existing Entra ID App: $clientId" -ForegroundColor Green                
        } else {
            $result = Register-PnPEntraIDAppForInteractiveLogin -ApplicationName $adminAppName -SharePointDelegatePermissions "AllSites.FullControl" -Tenant $tenantUrl -Interactive 
            $regexMatch = $result | Select-String -Pattern '@{AzureAppId/ClientId=' -AllMatches
            if ($regexMatch) {
                $clientId = $regexMatch -replace ".*=" -replace "}"
                Write-Host "Created Entra ID App with client id: $clientId" -ForegroundColor Green                
            } else {
                Write-Error "Failed to get id"
                return
            }
        }
    } catch {
        Write-Error "Failed to connect to SharePoint site: $_"
            return
    }

    Write-Host "Connecting to Sharepoint admin" -ForegroundColor Green
    $SPAdminConnection = Connect-PnPOnline $adminUrl -ClientId $clientId -Interactive -ReturnConnection 

     # Create new site
    try {
       New-PnPSite -Type TeamSite -Title $siteTitle -Alias $alias -Owner $owner -Connection $SPAdminConnection
        Write-Host "Created site" -ForegroundColor Green
    } catch {
        Write-Host "Error:"$_.Exception.Message -f Red
    }

    try {
        Grant-PnPAzureADAppSitePermission -AppId $appId -DisplayName $displayName -Site $siteUrl -Permissions Write -Connection $SPAdminConnection
        Write-Host "Granted permission to site" -ForegroundColor Green
    } catch {
        Write-Error "Failed to grant permission to site: $_"
            return
    }
